// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ debugStr.cpp ]		Auter : KENSUKE WATANABE
//											Data  : 2017/04/27
//
// -------- -------- -------- -------- -------- -------- -------- --------
#ifdef _DEBUG		// Debuĝݎs

//=============================================================================
// CN[h
//=============================================================================
#include "main.h"
#include <assert.h>
#include "debugStr.h"
#include "renderer.h"

//-----------------------------------------------------------------------------
// ÓIoϐ
//-----------------------------------------------------------------------------
std::unordered_map<std::string, CDebugStr*> CDebugStr::m_umapDebugStr;

//-----------------------------------------------------------------------------
// RXgN^
//-----------------------------------------------------------------------------
CDebugStr::CDebugStr()
{

}

//-----------------------------------------------------------------------------
// fXgN^
//-----------------------------------------------------------------------------
CDebugStr::~CDebugStr()
{

}

//-----------------------------------------------------------------------------
// 
//-----------------------------------------------------------------------------
void CDebugStr::Init(int line, std::string name, std::vector<float> vecVal)
{
	assert(!vecVal.empty() && "lł");

	// l̑
	m_nLine = line;
	m_nNumValue = vecVal.size();
	m_aName = name;
	for (int i = 0; i < m_nNumValue; i++)
	{
		m_vecValue.push_back(vecVal[i]);
	}

	// ̐ݒ
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();
	D3DXCreateFont(pDevice,		// foCX
		18,						// ̍
		0,						// ̕(0ɂƍɍ킹䗦ɂȂ)
		0,						// tHg̑(0ƃftHg)
		0,						// ~bv}bvidȂ)@fobOȂ̂ŉĂ[
		false,					// C^bN
		SHIFTJIS_CHARSET,		// tHg̕Zbg
		OUT_DEFAULT_PRECIS,		// tHgvȂ̎w
		DEFAULT_QUALITY,		// IԃtHg̃NIeB
		DEFAULT_PITCH,			// sb`ƃt@~[
		"Terminal",
		&m_pDebugFont);
}

//-----------------------------------------------------------------------------
// XV
//-----------------------------------------------------------------------------
void CDebugStr::Update(void)
{
	std::string temp;
	for (int nCntLine = 0; nCntLine < DEBUG_DISPLAY_LINE; nCntLine++)
	{
		if (m_nLine == nCntLine)
		{
			// [\ + : ]
			temp += (m_aName + ": ");
			std::string strBuff;

			// [l + , l + , l + ...]
			for(int i = 0; i < m_nNumValue; i++)
			{
				strBuff += std::to_string(m_vecValue.at(i));

				if (i != m_nNumValue - 1)strBuff += ", ";
			}
			temp += strBuff;
		}
		// sĉs
		if (nCntLine >= 1)temp += "\n";
	}
	m_strDebug = temp;
}

//-----------------------------------------------------------------------------
// `
//-----------------------------------------------------------------------------
void CDebugStr::Draw(void)
{
	RECT rect = { 0, DEBUG_DISPLAY_POS_Y, SCREEN_WIDTH, SCREEN_HEIGHT };	// fobO\̈
	m_pDebugFont->DrawText(
		nullptr,							// foCXReLXg nullptrłł
		&m_strDebug[0],			// 
		-1,
		&rect,								// ͈
		DT_LEFT,							// `@ DT_LEFT:l
		D3DCOLOR_RGBA(255, 255, 0, 255)		// F
	);
}

//-----------------------------------------------------------------------------
// SXV
//-----------------------------------------------------------------------------
void CDebugStr::UpdateAll(void)	
{
	std::for_each(m_umapDebugStr.begin(), m_umapDebugStr.end(), [](std::pair<const std::string, CDebugStr*> &umapDebugStr) {umapDebugStr.second->Update(); });
}

//-----------------------------------------------------------------------------
// S`
//-----------------------------------------------------------------------------
void CDebugStr::DrawAll(void)
{
	std::for_each(m_umapDebugStr.begin(), m_umapDebugStr.end(), [](std::pair<const std::string, CDebugStr*> &umapDebugStr) {umapDebugStr.second->Draw(); });
}

//-----------------------------------------------------------------------------
// S
//-----------------------------------------------------------------------------
void CDebugStr::ReleaseAll(void)
{
	// Rei𖖔܂Ń[v
	for (auto it = m_umapDebugStr.begin(); it != m_umapDebugStr.end();)
	{
		// vf(second)̕\p̒l̃NA
		m_umapDebugStr[it->first]->m_vecValue.clear();

		// vf(second)̃tHg̉
		if (m_umapDebugStr[it->first]->m_pDebugFont != nullptr)
		{
			m_umapDebugStr[it->first]->m_pDebugFont->Release();
			m_umapDebugStr[it->first]->m_pDebugFont = nullptr;
		}
		// vf(second)̉
		if (m_umapDebugStr[it->first] != nullptr)
		{
			delete m_umapDebugStr[it->first];
			m_umapDebugStr[it->first] = nullptr;
		}
		m_umapDebugStr.erase(it++);		// t@CpX폜
	}
	// gɂ(SvfNA)
	m_umapDebugStr.clear();
}

//-----------------------------------------------------------------------------
// fobOݒ
//-----------------------------------------------------------------------------
void CDebugStr::Set(std::string name, std::vector<float> vecVal)
{
	// vf̗Lm߂
	if (m_umapDebugStr.count(name) == 1)
	{// ܂
		assert(!vecVal.empty() && "lł");

		for (int i = 0; i < m_umapDebugStr[name]->m_nNumValue; i++)
		{
			m_umapDebugStr[name]->m_vecValue[i] = vecVal[i];
		}
	}
}

//-----------------------------------------------------------------------------
// fobO
//-----------------------------------------------------------------------------
void CDebugStr::Create(int line, std::string name, std::vector<float> vecVal)
{
	// CX^X̐
	CDebugStr *debugStr = new CDebugStr();

	// vf̒ǉ
	m_umapDebugStr[name] = debugStr;

	// 
	debugStr->Init(line, name, vecVal);
}

#endif

